<?php
require "config.php";
include "nav.php";

	if (!isset($_COOKIE['id'])) {
		header("Location: reglog.php");
		exit;
	}

	$kosar = [];
	if (!empty($_COOKIE['kosar'])) {
		$elemek = explode(',', $_COOKIE['kosar']);
		foreach ($elemek as $elem) {
			$resz = explode(':', $elem);
			$jegy_azonosito = $resz[0] ?? '';
			$mennyiseg = $resz[1] ?? '';
			if ($jegy_azonosito != '' && $mennyiseg != '' && $mennyiseg > 0) {
				if (!isset($kosar[$jegy_azonosito])) {
					$kosar[$jegy_azonosito] = 0;
				}
				$kosar[$jegy_azonosito] += $mennyiseg;
			}
		}
	}

	if (isset($_POST['mennyiseg'])) {
	$uj_kosar = [];
	foreach ($_POST['mennyiseg'] as $jegy_azonosito => $mennyiseg) {
		if ($mennyiseg > 0) {
			$uj_kosar[$jegy_azonosito] = $mennyiseg;
		}
	}

	$parok = [];
	foreach ($uj_kosar as $id => $mennyiseg) {
		$parok[] = $id . ':' . $mennyiseg;
	}

   setcookie('kosar', implode(',', $parok), time() + 3600, '/');
		header("Location: cart.php");
		exit;
	}

	$vegosszeg = 0;
	$jegyek_lista = [];

	if (!empty($kosar)) {
		$azonositok = implode(',', array_keys($kosar));
		$lekerdezes = "
			SELECT tickets.*, events.title FROM tickets JOIN events ON events.id = tickets.event_id WHERE tickets.id IN ($azonositok) ORDER BY events.title;
		";

	$talalt = $conn->query($lekerdezes);
	if ($talalt && $talalt->num_rows > 0) {
		while ($talalt_rendezvenyek = $talalt->fetch_assoc()) {
			$azonosito = $talalt_rendezvenyek['id'];
			$mennyiseg = $kosar[$azonosito];
			$talalt_rendezvenyek['mennyiseg'] = $mennyiseg;
			$talalt_rendezvenyek['osszesen'] = $mennyiseg * $talalt_rendezvenyek['price'];
			$vegosszeg += $talalt_rendezvenyek['osszesen'];
			$jegyek_lista[] = $talalt_rendezvenyek;
		}
	}
}
?>
	<!DOCTYPE html>
	<html lang="hu">
	<head>
		<meta charset="UTF-8">
		<title>Kosár</title>
		<link rel="stylesheet" href="css/styles.css">
	</head>
	<body>
		<div class="content">
		<section class="cart">
<h1>Kosár</h1>

<?php if (empty($jegyek_lista)): ?>
	<p class="cart-empty">A kosár üres.</p>
<?php else: ?>
	<form method="post">
	<table class="table">
	<thead>
		<tr>
		<th>Rendezvény</th>
		<th>Jegy</th>
		<th>Ár</th>
		<th>Mennyiség</th>
		<th>Összesen</th>
		</tr>
	</thead>
	<tbody>
	<?php foreach ($jegyek_lista as $egy_jegy): ?>
		<tr>		
		<td><?= ($egy_jegy['name']) ?></td>
		<td><?= $egy_jegy['price'] ?> Ft</td>
		<td>
			<input type="number" name="mennyiseg[<?= $egy_jegy['id'] ?>]" min="0" value="<?= $egy_jegy['mennyiseg'] ?>">
		</td>
		<td><?= ($egy_jegy['osszesen']) ?> Ft</td>
		</tr>
	<?php endforeach; ?>
	</tbody>
	<tfoot>
		<tr>
		<td colspan="4" class="right">Végösszeg:</td>
		<td><strong><?= $vegosszeg?> Ft</strong></td>
		</tr>
	</tfoot>
	</table>

	<div class="row end">
	<button class="btn" type="submit">Mennyiségek frissítése</button>
	<a class="btn" href="checkout.php">Rendelés véglegesítése</a>
	</div>
	</form>
<?php endif; ?>

	</section>
	</div>

	</body>
	</html>